#!/bin/sh

FRAMEWORKS=/System/Library/PrivateFrameworks
FRAMEWORKS_ALT=/System/Library/PrivateFrameworks_Alt
BACKUP=backup
ECLIPSE_FRAMEWORKS_SOURCE=./PUT_OLD_FRAMEWORKS_HERE
ECLIPSE_DIR=${FRAMEWORKS_ALT}/WebObjects5_2
XCODE_DIR=${FRAMEWORKS_ALT}/WebObjects5_2_3


# backup existing files
echo backing up WO 5.2.3 files...
if [ -r ${BACKUP} ]; then
sudo rm -r ${BACKUP}
fi

sudo mkdir ${BACKUP}
sudo cp -r ${FRAMEWORKS}/IDEServices.framework ${BACKUP}/IDEServices.framework 
sudo cp -r ${FRAMEWORKS}/WODevKit.framework ${BACKUP}/WODevKit.framework


# remove the originals if the backups have been made
if [ -r ${BACKUP}/WODevKit.framework ] && [ -r ${BACKUP}/IDEServices.framework ]; then
sudo rm -r ${FRAMEWORKS}/IDEServices.framework
sudo rm -r ${FRAMEWORKS}/WODevKit.framework
fi


# create the directory structures
if [ ! -r ${FRAMEWORKS_ALT} ]
then
echo creating private frameworks alt directory: ${FRAMEWORKS_ALT}
sudo mkdir ${FRAMEWORKS_ALT}
fi

if [ ! -r ${XCODE_DIR} ]; then
echo setting up XCode private frameworks directory: ${XCODE_DIR}
sudo mkdir ${XCODE_DIR}
sudo cp -r ${BACKUP}/IDEServices.framework ${XCODE_DIR} 
sudo cp -r ${BACKUP}/WODevKit.framework ${XCODE_DIR}
fi

if [ ! -r ${ECLIPSE_DIR} ]; then
echo setting up Eclipse/WOLips private frameworks directory: ${ECLIPSE_DIR}
sudo mkdir ${ECLIPSE_DIR}
sudo cp -r ${ECLIPSE_FRAMEWORKS_SOURCE}/IDEServices.framework ${ECLIPSE_DIR}
sudo cp -r ${ECLIPSE_FRAMEWORKS_SOURCE}/WODevKit.framework ${ECLIPSE_DIR}
fi

if [ ! -r ${FRAMEWORKS}/PBXRemoteClient.framework ]; then
sudo ln -s ${FRAMEWORKS}/DevToolsRemoteClient.framework ${FRAMEWORKS}/PBXRemoteClient.framework
fi

#setup system to use XCode
./setup_xcode.sh